(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 14.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     30454,        643]
NotebookOptionsPosition[     29693,        623]
NotebookOutlinePosition[     30089,        639]
CellTagsIndexPosition[     30046,        636]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{
  "Get", "[", "\"\<C:\\\\Users\\\\noura\\\\Desktop\\\\m\\\\lce.m\>\"", "]"}], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "This", " ", "file", " ", "requires", " ", "the", " ", "Marco", " ", 
     "Sandri", " ", "package", " ", "to", " ", "be", " ", "downloaded"}], ",",
     " ", 
    RowBox[{"it", " ", "can", " ", "be", " ", "downloaded", " ", 
     RowBox[{
      RowBox[{"from", "[", 
       RowBox[{
        RowBox[{"https", ":"}], "//", 
        RowBox[{
         RowBox[{"www", ".", "msandri", ".", "it"}], "/", 
         RowBox[{"soft", ".", "html"}]}]}], "]"}], "."}]}]}], 
   "*)"}]}]], "Input",
 CellChangeTimes->{
  3.931908069237932*^9, {3.931908110589626*^9, 3.931908130356199*^9}, {
   3.9388698859015923`*^9, 3.938869897083746*^9}, {3.9555232038666935`*^9, 
   3.9555232454149666`*^9}, {3.9555238086717377`*^9, 
   3.9555238346191235`*^9}, {3.958652834987047*^9, 3.958652850141794*^9}, {
   3.975587858994257*^9, 3.9755878627487698`*^9}, {3.9755880026336327`*^9, 
   3.975588007250023*^9}, {3.975588039156128*^9, 3.9755881111848774`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"efd8c9d1-3fc6-8d49-af86-dc698f9244bd"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"r", " ", "=", " ", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", " ", "=", " ", "0.2"}], ";"}]}], "Input",
 CellChangeTimes->{{3.931913872295067*^9, 3.9319138801265087`*^9}, 
   3.931914378735279*^9, {3.9319145118818836`*^9, 3.9319145129124184`*^9}, {
   3.938869914776539*^9, 3.9388699151983414`*^9}, {3.9555241735118103`*^9, 
   3.955524186504883*^9}, {3.9555254815451202`*^9, 3.9555254876416435`*^9}, {
   3.975408138808275*^9, 3.9754081399175625`*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"178a0811-e2a1-d04b-9434-98b4a4f42728"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"alpha", " ", "=", " ", "0.95"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"h", "=", " ", "0.3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"h1", " ", "=", " ", 
   RowBox[{
    RowBox[{"h", "^", "alpha"}], "/", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "alpha"}], "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.97540814146702*^9, 3.9754081431199207`*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"5b6d1f55-c288-4549-80ef-4827a891015c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ly", "=", 
   RowBox[{"Quiet", "@", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"G", "[", 
         RowBox[{"{", 
          RowBox[{"x_", ",", "y_"}], "}"}], "]"}], ":=", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"x", "+", 
           RowBox[{"h1", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"r", "*", "x"}], "-", 
              RowBox[{"x", "*", "y"}]}], ")"}]}]}], ",", " ", 
          RowBox[{"y", "+", 
           RowBox[{"h1", 
            RowBox[{"(", 
             RowBox[{"\[Sigma]", "-", 
              RowBox[{
               FractionBox["1", "r"], "y"}], "-", 
              RowBox[{"d", "*", "x"}], "+", 
              RowBox[{"x", "*", "y"}]}], ")"}]}]}]}], "}"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"\[Sigma]", ",", 
         RowBox[{
          RowBox[{"LCEsD", "[", 
           RowBox[{"G", ",", 
            RowBox[{"{", 
             RowBox[{"0.31", ",", "2"}], "}"}], ",", "1000", ",", "100", ",", 
            RowBox[{"LCEsPlot", "\[Rule]", "False"}]}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Sigma]", ",", "0.35", ",", "0.5", ",", "0.0005"}], "}"}]}], 
     "]"}]}]}], ";"}], "\n", 
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"ly", ",", 
   RowBox[{"Frame", "->", "True"}], ",", 
   RowBox[{"FrameLabel", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<\[Sigma]\>\"", ",", "\"\<Maximum Lyapunov Exponents\>\""}], 
     "}"}]}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{"Black", ",", "Thick"}], "}"}]}], ",", 
   RowBox[{"FrameStyle", "->", "Black"}], ",", 
   RowBox[{"LabelStyle", "->", 
    RowBox[{"Directive", "[", 
     RowBox[{"Black", ",", "Bold", ",", "14"}], "]"}]}], ",", 
   RowBox[{"ImageSize", "->", "Large"}]}], " ", "]"}]}], "Input",
 CellChangeTimes->{{3.931911783804884*^9, 3.93191182458218*^9}, {
   3.931912567580719*^9, 3.931912569795435*^9}, {3.9319126426584396`*^9, 
   3.9319126447379436`*^9}, {3.9319133038087645`*^9, 
   3.9319133108294983`*^9}, {3.931913355106928*^9, 3.931913356800717*^9}, {
   3.931913566060444*^9, 3.931913566362343*^9}, {3.9319142147118073`*^9, 
   3.931914214844805*^9}, {3.9319145276545277`*^9, 3.931914541273081*^9}, {
   3.9388699305268917`*^9, 3.9388699321835175`*^9}, {3.9555240859478474`*^9, 
   3.955524161552927*^9}, {3.9555243438490314`*^9, 3.955524391590435*^9}, {
   3.955525471193243*^9, 3.9555254786468906`*^9}, {3.955525538118866*^9, 
   3.955525541688999*^9}, {3.955525579946905*^9, 3.955525600229086*^9}, {
   3.9555256520072727`*^9, 3.955525657868492*^9}, {3.9588111562548275`*^9, 
   3.958811158404154*^9}, 3.958811206135811*^9, {3.9588113250521946`*^9, 
   3.9588113526793976`*^9}, {3.9598650956559467`*^9, 
   3.9598650981491337`*^9}, {3.9600244686615143`*^9, 3.9600244757632504`*^9}, 
   3.960024560659464*^9, 3.960024614333025*^9, {3.975408183682539*^9, 
   3.9754082214635143`*^9}, 3.9755878007809772`*^9},
 CellLabel->"In[7]:=",ExpressionUUID->"e974f53c-ffd5-cd43-a3d9-d934b3ee9aa0"],

Cell[BoxData[
 GraphicsBox[{{}, 
   InterpretationBox[{
     TagBox[{{}, {}, 
       TagBox[
        {GrayLevel[0], PointSize[
          NCache[
           Rational[1, 90], 0.011111111111111112`]], Thickness[Large], 
         LineBox[CompressedData["
1:eJw113lczdn/B/BUE5JkmSGT0CqJsTRCvEpaibImCdG+3dvdktImka8tY83I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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]},
      {"WolframDynamicHighlight", <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
     StyleBox[
      DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
        Slot["HighlightElements"], 
        Slot["LayoutOptions"], 
        Slot["Meta"], 
        Charting`HighlightActionFunction["DynamicHighlight", {{{}, {}, 
           Annotation[{
             Hue[0.67, 0.6, 0.6], 
             Directive[
              PointSize[
               Rational[1, 90]], 
              AbsoluteThickness[2], 
              GrayLevel[0], 
              Thickness[Large]], 
             Line[CompressedData["
1:eJw113lczdn/B/BUE5JkmSGT0CqJsTRCvEpaibImCdG+3dvdktImka8tY83I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              "]]}, "Charting`Private`Tag#1"]}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PanelPlotLayout" -> <||>, 
            "PlotRange" -> {{0.346875000000001, 0.5}, {-0.009349249445512806, 
             0.006033641915347957}}, "Frame" -> {{True, True}, {True, True}}, 
            "AxesOrigin" -> {0.346875000000001, 0}, 
            "ImageSize" -> {576, 576/GoldenRatio}, "Axes" -> {True, True}, 
            "LabelStyle" -> {
              Directive[
               GrayLevel[0], Bold, 14]}, "AspectRatio" -> GoldenRatio^(-1), 
            "DefaultStyle" -> {
              Directive[
               PointSize[
                Rational[1, 90]], 
               AbsoluteThickness[2], 
               GrayLevel[0], 
               Thickness[Large]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ListLinePlot, "GroupHighlight" -> False|>|>]]& )[<|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, 
           "PlotRange" -> {{0.346875000000001, 0.5}, {-0.009349249445512806, 
            0.006033641915347957}}, "Frame" -> {{True, True}, {True, True}}, 
           "AxesOrigin" -> {0.346875000000001, 0}, 
           "ImageSize" -> {576, 576/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {
             Directive[
              GrayLevel[0], Bold, 14]}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              PointSize[
               Rational[1, 90]], 
              AbsoluteThickness[2], 
              GrayLevel[0], 
              Thickness[Large]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ListLinePlot, "GroupHighlight" -> False|>|>],
       ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
        4.503599627370496*^15, -4.503599627370496*^15}}],
      Selectable->False]},
    Annotation[{{{}, {}, 
       Annotation[{
         Hue[0.67, 0.6, 0.6], 
         Directive[
          PointSize[
           Rational[1, 90]], 
          AbsoluteThickness[2], 
          GrayLevel[0], 
          Thickness[Large]], 
         Line[CompressedData["
1:eJw113lczdn/B/BUE5JkmSGT0CqJsTRCvEpaibImCdG+3dvdktImka8tY83I
ViFMSBPiVEZDfFFy90X2Ml+7GEt+t3M+v/NPjx633r3PeS/PR8MjkudGGhoY
GLh0MzDo+hpFjxSZdYGN/F/iyRTdnM27k6Q4/T3sj8X/DYVFyKTK62IpioZZ
Jf9mGIUnd21U/66V4p+GsGNT78fjor+ZoXO+FPHNbsf/uCfA1voPI8K2SpFX
Zp5a93A6VtGAUkxrW9d7GI+PrmhXiqVYl59wrZdjHMxdzv7+qkyKsPHpQwN6
huNRSdFfwyqkiAgvbF99bSmqrfNeBFdL4Vw2p7u40xX65Prl1koRmjvhyoX7
PETQBKV4VP508MqsVEzc6Ln8yV0pDAIyty6aJkRXdj8p9J9Ptcxq+y8frWkD
Tvu2SiGR8wM+ruGh6t23ltQ2KQxNPYsk16KwKeHZl+NvpLDked+4U7ccy+mF
pTAd0T/H9VwEXMO7bixD5/Xxsdt+TIKp7AhvqqkMhx2DF2cdFYA+Xz8Z+ob+
Grp0TyrodQfLoPI+ILNcKQJNz0aGaRtmJV1azAcN5yzDXo1t/tp+SRhPjwxn
W2ySTtjGosdJq9BVU2To4Y8Mx+gIaOxMsnd6yfDIyKHyhekqdL1ew0wZmk9V
15SNSYL+src/zpMhwP5I0yIPAcJoQWTYEbzwQn8jCcbSgDK0hNY+qDkiQle0
TQkySCWhB2PWCKAvblyNUIaqROewxiIeKlJitv8vXQaT8mdx5nMT0FUN6zwZ
Kqz7P++Ij0IoLbAMV+smDGh9EoExNEEZdv9eZDRpYjyMF3ZVWIZf6nSjn2xP
QVd2j0pkULS/TLQ9LIK+GPqKyLBRebPggrEEubWNh7yr9PmNT37dGiUCbb8r
MhgXXuYP7ykAbZcG/XtuG9TduZgHWt7bMnxrObBo6bd4sHLIMDQ//HlJcxTo
8+n09So1PJHQHgl63Wf6z5eOzly7KAk0vVcy7GzxCRjgIgAN91GGwRUeCyz2
iWFAjxz53/96tlklwv3UNoexPeQI9H911u+ACCfeNAdGWMjxp8TB+pNQgEz9
6+0YJEdO2Xc/Wyc+5tOGlqP0Ro/hW3clwokWRI75R2OHjBLFoLOlK6AcEn5G
9smQaNwL7OpoOe4M1NZVZiXjWMNMfUvLodXaDYtOFCCDdqAcvXp79D76HzHm
0gGRw8fytF1ZoQQOtMBy3PhjSZbYSYyvx7sSlGNf28h5m+KEoOMbJ8ecTgeb
wTNSUNo1bilyFNybn29hwgMdjzQ5ImdVK35xj0cQHTg5XM6nqms8Y0Dbb5Mc
F1w7bVpqk/C5q112yNHk4rHuXyMBaHmL5LAadMmovl2Eo13lOCJHX32wS1Wp
oM93Uo4znvdCExtEmE0HWI7bC16Ueh0TgaZXI0fW1TvWky4KQMP9pf/7x0J/
8DnKxy165Pg8KXyWtiUJ+mbRT7AcIq/lNRuWxaFr2sZo5Kg2yRB7KRMwky4E
OcZ3lPTsb5aCYbSh5TC0G/K6zEiErm1V/0GORw/K6040S9BIA8qx/23GsW9a
Mbqi2ZkoUOQz2dXtdzH0xdW3tALz89oaBkaI4M8WDGatUbU+yxaAritrBSoH
7CssTuODrhcH/c/v89h8Ny8JdB2MUeAnu5lBa0rjQcd3ogIFr2zGVmTyQMcN
+nhTphy8dk4AOh6+CqzfON8pwVMM2s5zFHhqX11pUZkK2n4hCpQr4kLfq4Sg
7bJcgeCidOfLV8Sg5Y1RwCV3Ly83TQRaDp4CFdtiI4TnBaDPl6rA0LxRflvr
+KDXzVbALvr5jVeuyaDpbdTnk9Zo/WtJImi47QrENqbtDynmYy89Chh8M1rv
KRCiazs3HtLHCzxhK7okhhddqAp9H41NTT2VikF0ISgQ0l/hEfOTCPrL6hta
gdvkbu7eBjEoH/X6eOW23n2+iEDXfaMC299aBC0QCUHXc7MCqyo63fecTwFd
pyoFJCW2TfIrPND190iBXZc6JqQLk0DX1QsFSivyrMxv80DXyzsFjoV32l4N
FICugy/6+/xT6RHhJwIdX2MlDj+rCxnZLgZb+Eqscco1za6UgI7HACXM/03a
Gqx/b9rOVkqU7hNUpg8SgbafnRJPHVasvLtHBNouLkoo6h3nXFEIQcvrqkTT
n1buETUC0HJMVUIqM3tvIUoBfT5vJTY0+doIevNBrxuoxCFee8hcy2TQ9BYq
8XzQgOhx4Qmg4cKVcJeaeVZMiwfzXAnLhUNcC77Hg3muhFnemfTWUYmc50pE
7A+q9jRK4jxXgn/txMPzq5I4z5XouCcQTwtL4jzX//5s57V9PidynivhW+1j
bh+YyHmuRIV3a2XflQmc50oc/Tq4+YRfPOe5Ep1b3q1ONY3jPFditktnh7oy
hvNciQEbRvj1mx/Nea7EvjkrvnZ7H8l5roT4zM6Zj4pXcZ4r0fpblWnhipWc
50rU9dyECx4RnOdKPKziB/w8fQXnuRL2vZ/9PDP6/z1XYlfx+bevly7jPFdh
9IEmo2DncM5zFVrcJS5WLks5z1VQ8i/5FoSEcZ6r0DPw5eRzh5dwnquwX3PV
073bEs5zFYICfzC9HBfKea7CjIJ+595IF3Oeq/Ba+sHs+rTFnOcqjLJybJ67
P4TzXAXP3M3dTrYv4jxX4eoxE4fb9os4z1V4lKnbHhewkPNchbu+fvtqFyzg
PFdhQLvHkFTv+ZznKhQav1+YNXAe57kKkvWTF7y7Ecx5rsIBwevRnaFBnOcq
GFqMHvr79kDOcxX+Hlxcam4bwHmuwi471bGsKB/OcxXisu+tmBAynfNcf/+M
hJfatimc5yrkexWafReN4zxX4WKfH919zgzjPFfB/AcXr7MyQ8I818e3f9xZ
93QkYZ6roIlcfeboRjfCPFfBYNyGILf8SYR5roLlhPPpNzCZMM9VcF7+oG9m
9VTCPFfhlYV5VPmI6YR5rsa8ph+WHa31IZTfHmocnWrmlV/gT5jnatTsePJx
8m4/QnkbpMbGIImy7ZQvYZ6rochKqb38xYdQPkaogT2xm87t9CHMczXuNxrx
NuT6ELqeJ6nBK6wviWvwIcxzNe4sMVYWh/kSuv781aiI5P8W7eVHmOdqOBxv
/PBC4k+Y52r8nLRnWtXHAMI8VyP9win7J7WzCPNcjSqT92bezbMJ81yNMpOx
rqd2BhHmuRqd7aN/Hf80mDDP9fl8Stg9Yck8wjxXQ+K478a2D/MJ81yN4Od1
f+ZWLSTMczUszWcpiopDCPNcjav7vVccPBtKmOdqDM35dcuCN2GEea5GPH+Z
3ZewZYR5rsZhl8/zij8vJ5+o52o4vvk0o8+SCMI8V+Oib8zNDzdWksMUJDWc
xA6rAydHEua5Gut35DcnSCLJLLoQ1EiMvGYQvD6SMM/VeNne73ju+0jSQQui
hkmfhyFJd6II81yNwgvr4lMNY8hBCpwGR8cX9yrNjyHMcw3CUrsfmOkRQ5jn
GtzrVXtzWWc0YZ5rEFQ9Q/D+VjRhnmuw+aGp/d2KaMI814A4rP0oKI8mzHMN
vvyyzE9RE02Y5xqEfjS+sPhxNGGeazD7+mNDm+ExhHmuQY9jhk9iUmII81yD
ZAxK3yCLIcxzDTa518X3DIolzHMNvFKnFZSpYgnzXIOhs95J56XFEea5BgEl
N9NcR8UT5rkGN7KjI068iSfMcw1s7Ehf35sJhHmu/35pkG3LhUTCPNfAPXuX
3PtKEmGea/B8whDLUkUyYZ5rYPY4PY+3nkeY5xo8lJh0OI3iE+a5BvsXH3FK
1vAJ81yfT15nUbc9KYR5roHh3p3dPRYKCPNcA597fy9zKRcQtk41WDCjPmJL
qYAwzzUwcCrtZtEsIMxzDa49yBxc7yYkzHMN9kobShubhIR5rsGJ/tZuA+1E
hHmuxW+jP7nwvggJW/haTBt62D37vpAwz7VIdrOLzqsWEua5FqUL2/7pUyYk
zHMt4o9sv60+JCTMcy2CToeltBwTEua5Frkmq923XBIS5rkWo98Kn21RCAnz
XIsmzZCRkYYiwjzXoqRg3OwqVxFhnmuR5Z0e4SUQEea5Fk7ZZye/uCgizHMt
Om8nuZebibn/z7XYaPlBURwjJsxzLbq/ynxnfEdMmOdafJbFXnf1kBDmuRZf
/R0Wl9dICPNci7vzbx/pmJFKmOdabO4jHHpGkUqY51pkW7tlLVqzmjDPtXAf
d/rcB6c0wjzXYkifGuOUx2mEea7F8CarxGFlawjzXAsz6dSTXrHphHmuf9/q
W1bTw9MJ81wL66en3+9PSifMc/17vnQW82rSCfNci8vX/T9H+mYQ5rkWfrP9
5X+oMwjzXIuXpbODp1RkEOa5Fg8PbWs+kptBmOc6GEUvSc9clkGY5zq0jq30
jdHHY57r4NPUvFHgnkGY5zp0GDkK9kzLIMxzHdxLULAiMIMwz3X40fdve8Rk
EOa5Dv/wC61ObskgzHMdPtX/PWNqbQZhnusQfcUzq+xrBmGe6xCf+a+yzmst
YZ7r0LR6YMD6nWsJ81yHdf2bHPu9XUuY5zo4FltfLF2cSZjnOkR0GxZ//FYm
YZ7rsD603q3JPoswz3WQT50sLIrPIsxzHca4zb3TqzqLMM91uJWtfRbXK5sw
z3U4efDUgyuR2YR5roOLy4PK0IZsIqcLXwde2LzDH0bmEOa5DqtF77bZZOWQ
HDpwOuTLXrVYi3II81yH8W65G2/l5pBR9MI6TKzx/GnE+RzOcx0ksye2dRjn
Ein1XIeSLQ+Nz9nncp7rMHv6HdefzXJJFh1gHXa3Do1qfZ/Dea7Dn1kr34Y+
yiEj6QPq69FjtUuVPIfz/AEcY2f2sL+fQ/4PJnE/Ow==
          "]]}, "Charting`Private`Tag#1"]}}, <|
     "HighlightElements" -> <|
       "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
      "LayoutOptions" -> <|
       "PanelPlotLayout" -> <||>, 
        "PlotRange" -> {{0.346875000000001, 0.5}, {-0.009349249445512806, 
         0.006033641915347957}}, "Frame" -> {{True, True}, {True, True}}, 
        "AxesOrigin" -> {0.346875000000001, 0}, 
        "ImageSize" -> {576, 576/GoldenRatio}, "Axes" -> {True, True}, 
        "LabelStyle" -> {
          Directive[
           GrayLevel[0], Bold, 14]}, "AspectRatio" -> GoldenRatio^(-1), 
        "DefaultStyle" -> {
          Directive[
           PointSize[
            Rational[1, 90]], 
           AbsoluteThickness[2], 
           GrayLevel[0], 
           Thickness[Large]]}, 
        "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), 
          "ScalingFunctions" -> {{Identity, Identity}, {
            Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
      "Meta" -> <|
       "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
        ListLinePlot, "GroupHighlight" -> False|>|>, 
     "DynamicHighlight"]], {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.346875000000001, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Maximum Lyapunov Exponents\"", HoldForm], TraditionalForm], 
     None}, {
     FormBox[
      TagBox["\"\[Sigma]\"", HoldForm], TraditionalForm], None}},
  FrameStyle->GrayLevel[0],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->Large,
  LabelStyle->Directive[
    GrayLevel[0], Bold, 14],
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
    "RangePadding" -> Scaled[0.05], "OptimizePlotMarkers" -> True, 
    "IncludeHighlighting" -> "CurrentSet", "HighlightStyle" -> Automatic, 
    "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0.346875000000001, 0.5}, {-0.009349249445512806, 
   0.006033641915347957}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.975587851172674*^9, 3.9755881831685257`*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"9a8bfca9-e174-524a-a015-e197294024f0"]
}, Open  ]]
},
WindowSize->{949, 521},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"14.1 for Microsoft Windows (64-bit) (July 16, 2024)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"38e46256-95ea-b240-b286-c4aa5066d2e5"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 1171, 26, 47, "Input",ExpressionUUID->"efd8c9d1-3fc6-8d49-af86-dc698f9244bd"],
Cell[1732, 48, 587, 10, 47, "Input",ExpressionUUID->"178a0811-e2a1-d04b-9434-98b4a4f42728"],
Cell[2322, 60, 502, 12, 66, "Input",ExpressionUUID->"5b6d1f55-c288-4549-80ef-4827a891015c"],
Cell[CellGroupData[{
Cell[2849, 76, 3165, 72, 110, "Input",ExpressionUUID->"e974f53c-ffd5-cd43-a3d9-d934b3ee9aa0"],
Cell[6017, 150, 23660, 470, 388, "Output",ExpressionUUID->"9a8bfca9-e174-524a-a015-e197294024f0"]
}, Open  ]]
}
]
*)

